/*
 * Decompiled with CFR 0.152.
 */
package com.example.doctoolkit.controller.user;

import com.example.doctoolkit.parser.ExifParser;
import com.example.doctoolkit.utils.Crypt;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Paths;
import java.util.HashMap;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.yaml.snakeyaml.Yaml;

@Controller
@RequestMapping(value={"/image"})
public class ImageController {
    private static final String UPLOAD_DIRECTORY = "upload";
    private static final String OUTPUT_DIRECTORY = "output";

    @GetMapping(value={"/"})
    public String index(Model model) {
        model.addAttribute("title", (Object)"EXIF Parser");
        model.addAttribute("description", (Object)"Upload Image To Parse");
        model.addAttribute("message", (Object)"Have a try?");
        model.addAttribute("action", (Object)"/image/upload");
        return UPLOAD_DIRECTORY;
    }

    @PostMapping(value={"/upload"})
    public String handleFileUpload(@RequestParam(value="uploadFile") MultipartFile file, Model model) {
        if (file.isEmpty()) {
            model.addAttribute("title", (Object)"EXIF Parser");
            model.addAttribute("description", (Object)"Upload Image To Parse");
            model.addAttribute("message", (Object)"Please select a file to upload");
            model.addAttribute("action", (Object)"/image/upload");
            return UPLOAD_DIRECTORY;
        }
        try {
            File parseDir;
            String fileName = file.getOriginalFilename();
            if (!(fileName == null || fileName.endsWith(".jpg") || fileName.endsWith(".png") || fileName.endsWith(".jpeg") || fileName.endsWith(".gif"))) {
                model.addAttribute("title", (Object)"EXIF Parser");
                model.addAttribute("description", (Object)"Upload Image To Parse");
                model.addAttribute("message", (Object)"Only .jpg/.png/.jpeg/.gif files are allowed");
                model.addAttribute("action", (Object)"/image/upload");
                return UPLOAD_DIRECTORY;
            }
            String userDir = Crypt.md5((String)fileName);
            String uploadPath = File.separator + "tmp" + File.separator + UPLOAD_DIRECTORY + File.separator + userDir;
            String parsePath = OUTPUT_DIRECTORY + File.separator + userDir;
            File uploadDir = new File(uploadPath);
            if (!uploadDir.exists()) {
                uploadDir.mkdirs();
            }
            if (!(parseDir = new File(parsePath)).exists()) {
                parseDir.mkdirs();
            }
            String filePath = uploadPath + File.separator + fileName;
            File storeFile = new File(filePath);
            file.transferTo(storeFile);
            ExifParser exifParser = new ExifParser(filePath);
            File saveFile = new File(parsePath + File.separator + fileName);
            Yaml yaml = new Yaml();
            yaml.dump((Object)exifParser.exifResult, (Writer)new FileWriter(saveFile));
            return "redirect:/image/display?imageName=" + fileName;
        }
        catch (Exception ex) {
            model.addAttribute("title", (Object)"EXIF Parser");
            model.addAttribute("description", (Object)"Upload Image To Parse");
            model.addAttribute("message", (Object)"Something went wrong.");
            model.addAttribute("action", (Object)"/image/upload");
            ex.printStackTrace();
            return UPLOAD_DIRECTORY;
        }
    }

    @GetMapping(value={"/display"})
    public String display(@RequestParam(value="imageName") String imageName, Model model) throws FileNotFoundException {
        if (!imageName.isEmpty()) {
            String userDir = Crypt.md5((String)Paths.get(imageName, new String[0]).getFileName().toString());
            String parsePath = OUTPUT_DIRECTORY + File.separator + userDir + File.separator + imageName;
            if (new File(parsePath).exists()) {
                Yaml yaml = new Yaml();
                HashMap exifData = (HashMap)yaml.load((Reader)new FileReader(new File(parsePath)));
                model.addAttribute("exifData", (Object)exifData);
                return "display";
            }
        }
        model.addAttribute("title", (Object)"EXIF Parser");
        model.addAttribute("description", (Object)"Upload Image To Parse");
        model.addAttribute("message", (Object)"Have a try?");
        model.addAttribute("action", (Object)"/image/upload");
        return UPLOAD_DIRECTORY;
    }
}

