/*
 * Decompiled with CFR 0.152.
 */
package com.example.doctoolkit.controller.user;

import com.example.doctoolkit.parser.PDFParser;
import com.example.doctoolkit.utils.Crypt;
import com.example.doctoolkit.utils.ZipUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

/*
 * Exception performing whole class analysis ignored.
 */
@Controller
@RequestMapping(value={"/pdf"})
public class PDFController {
    private static final String UPLOAD_DIRECTORY = "upload";
    private static final String OUTPUT_DIRECTORY = "output";

    @GetMapping(value={"/"})
    public String index(Model model) {
        model.addAttribute("title", (Object)"PDF Parser");
        model.addAttribute("description", (Object)"Upload PDF To Parse");
        model.addAttribute("message", (Object)"Have a try?");
        model.addAttribute("action", (Object)"/pdf/upload");
        return "upload";
    }

    @PostMapping(value={"/upload"})
    public String handleFileUpload(@RequestParam(value="uploadFile") MultipartFile file, Model model) {
        if (file.isEmpty()) {
            model.addAttribute("title", (Object)"PDF Parser");
            model.addAttribute("description", (Object)"Upload PDF To Parse");
            model.addAttribute("message", (Object)"Please select a file to upload");
            model.addAttribute("action", (Object)"/pdf/upload");
            return "upload";
        }
        try {
            File parseDir;
            String fileName = file.getOriginalFilename();
            if (fileName != null && !fileName.endsWith(".pdf")) {
                model.addAttribute("title", (Object)"PDF Parser");
                model.addAttribute("description", (Object)"Upload PDF To Parse");
                model.addAttribute("message", (Object)"Only .pdf files are allowed");
                model.addAttribute("action", (Object)"/pdf/upload");
                return "upload";
            }
            String userDir = Crypt.md5((String)fileName);
            String uploadPath = File.separator + "tmp" + File.separator + "upload" + File.separator + userDir;
            String parsePath = "output" + File.separator + userDir;
            File uploadDir = new File(uploadPath);
            if (!uploadDir.exists()) {
                uploadDir.mkdirs();
            }
            if (!(parseDir = new File(parsePath)).exists()) {
                parseDir.mkdirs();
            }
            String filePath = uploadPath + File.separator + fileName;
            File storeFile = new File(filePath);
            file.transferTo(storeFile);
            PDFController.PDFHandle((String)filePath, (String)parsePath);
            return "redirect:/download/" + userDir + ".zip";
        }
        catch (Exception ex) {
            model.addAttribute("title", (Object)"PDF Parser");
            model.addAttribute("description", (Object)"Upload PDF To Parse");
            model.addAttribute("message", (Object)"Something went wrong.");
            model.addAttribute("action", (Object)"/pdf/upload");
            return "upload";
        }
    }

    protected static void PDFHandle(String filePath, String savePath) throws IOException {
        File file = new File(filePath);
        if (file.exists()) {
            String infoSavePath = savePath + File.separator + "PDFInformation.txt";
            String txtSavePath = savePath + File.separator + "PDFContent.txt";
            String imgSavePath = savePath + File.separator + "images";
            System.out.println(imgSavePath);
            PDFParser.getPDFInformation((String)filePath, (String)infoSavePath);
            PDFParser.extractTXT((String)filePath, (String)txtSavePath);
            PDFParser.extractImage((String)filePath, (String)imgSavePath);
            FileOutputStream fos = new FileOutputStream(new File(savePath + ".zip"));
            ZipUtils.toZip((String)savePath, (OutputStream)fos, (boolean)true);
        }
    }
}

