/*
 * Decompiled with CFR 0.152.
 */
package com.example.doctoolkit.parser;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import javax.imageio.ImageIO;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDDocumentOutline;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDOutlineItem;
import org.apache.pdfbox.text.PDFTextStripper;

/*
 * Exception performing whole class analysis ignored.
 */
public class PDFParser {
    public static String dateFormat(Calendar calendar) {
        if (null == calendar) {
            return null;
        }
        String date = null;
        String pattern = "yyyy-MM-dd HH:mm:ss";
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        date = format.format(calendar.getTime());
        return date == null ? "" : date;
    }

    public static void getPDFOutline(String filePath) {
        File file = new File(filePath);
        try {
            FileInputStream fis = new FileInputStream(file);
            PDDocument document = PDDocument.load((InputStream)fis);
            PDDocumentCatalog catalog = document.getDocumentCatalog();
            PDDocumentOutline outline = catalog.getDocumentOutline();
            if (outline != null) {
                for (PDOutlineItem item = outline.getFirstChild(); item != null; item = item.getNextSibling()) {
                    System.out.println("Item:" + item.getTitle());
                    for (PDOutlineItem child = item.getFirstChild(); child != null; child = child.getNextSibling()) {
                        System.out.println(" Child:" + child.getTitle());
                    }
                }
            }
            document.close();
            fis.close();
        }
        catch (Exception ex) {
            System.out.println(ex);
        }
    }

    public static void getPDFCatalog(String filePath) {
        File file = new File(filePath);
        try {
            FileInputStream fis = new FileInputStream(file);
            PDDocument document = PDDocument.load((InputStream)fis);
            PDDocumentCatalog catalog = document.getDocumentCatalog();
            PDDocumentOutline outline = catalog.getDocumentOutline();
            if (outline != null) {
                for (PDOutlineItem item = outline.getFirstChild(); item != null; item = item.getNextSibling()) {
                    System.out.println("Item: " + item.getTitle());
                }
            }
            document.close();
            fis.close();
        }
        catch (Exception ex) {
            System.out.println(ex);
        }
    }

    public static void getPDFInformation(String filePath, String infoSavePath) {
        File file = new File(filePath);
        try {
            FileInputStream fis = new FileInputStream(file);
            PDDocument document = PDDocument.load((InputStream)fis);
            PDDocumentInformation info = document.getDocumentInformation();
            String PDFInformation = "Pages: " + document.getNumberOfPages() + "\n";
            PDFInformation = PDFInformation + "Title: " + info.getTitle() + "\n";
            PDFInformation = PDFInformation + "Topic: " + info.getSubject() + "\n";
            PDFInformation = PDFInformation + "Author: " + info.getAuthor() + "\n";
            PDFInformation = PDFInformation + "keyword: " + info.getKeywords() + "\n";
            PDFInformation = PDFInformation + "Application: " + info.getCreator() + "\n";
            PDFInformation = PDFInformation + "PDF Maker: " + info.getProducer() + "\n";
            PDFInformation = PDFInformation + "Trapped: " + info.getTrapped() + "\n";
            PDFInformation = PDFInformation + "Build Time: " + PDFParser.dateFormat((Calendar)info.getCreationDate()) + "\n";
            PDFInformation = PDFInformation + "Modification time: " + PDFParser.dateFormat((Calendar)info.getModificationDate()) + "\n";
            OutputStreamWriter writer = new OutputStreamWriter(new FileOutputStream(infoSavePath));
            writer.write(PDFInformation);
            ((Writer)writer).close();
            document.close();
            fis.close();
        }
        catch (Exception ex) {
            System.out.println(ex);
        }
    }

    public static void extractTXT(String filePath) {
        File file = new File(filePath);
        try {
            FileInputStream fis = new FileInputStream(file);
            PDDocument document = PDDocument.load((InputStream)fis);
            PDFTextStripper stripper = new PDFTextStripper();
            String content = stripper.getText(document);
            System.out.println(content);
            document.close();
            ((InputStream)fis).close();
        }
        catch (Exception ex) {
            System.out.println(ex);
        }
    }

    public static void extractTXT(String filePath, String txtSavePath) {
        File file = new File(filePath);
        try {
            FileInputStream fis = new FileInputStream(file);
            PDDocument document = PDDocument.load((InputStream)fis);
            PDFTextStripper stripper = new PDFTextStripper();
            OutputStreamWriter writer = new OutputStreamWriter(new FileOutputStream(txtSavePath));
            stripper.writeText(document, (Writer)writer);
            ((Writer)writer).close();
            document.close();
            ((InputStream)fis).close();
        }
        catch (Exception ex) {
            System.out.println(ex);
        }
    }

    public static void extractImage(String filePath, String imgSavePath) throws IOException {
        File imgSaveDir = new File(imgSavePath);
        if (!imgSaveDir.exists()) {
            imgSaveDir.mkdir();
        }
        File file = new File(filePath);
        try {
            PDDocument document = PDDocument.load((File)file);
            int pages_size = document.getNumberOfPages();
            int j = 0;
            for (int i = 0; i < pages_size; ++i) {
                PDPage page = document.getPage(i);
                PDResources resources = page.getResources();
                Iterable xobjects = resources.getXObjectNames();
                if (xobjects == null) continue;
                for (COSName key : xobjects) {
                    if (!resources.isImageXObject(key)) continue;
                    try {
                        PDImageXObject image = (PDImageXObject)resources.getXObject(key);
                        File file_2 = new File(imgSavePath + File.separator + j + ".png");
                        FileOutputStream out = new FileOutputStream(file_2);
                        BufferedImage input = image.getImage();
                        ImageIO.write((RenderedImage)input, "png", out);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    ++j;
                }
            }
        }
        catch (Exception ex) {
            System.out.println(ex);
        }
    }
}

