/*
 * Decompiled with CFR 0.152.
 */
package com.example.doctoolkit.shiro;

import com.example.doctoolkit.shiro.UserRealm;
import java.util.Base64;
import java.util.LinkedHashMap;
import org.apache.shiro.mgt.RememberMeManager;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.spring.web.ShiroFilterFactoryBean;
import org.apache.shiro.web.mgt.CookieRememberMeManager;
import org.apache.shiro.web.mgt.DefaultWebSecurityManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ShiroConfig {
    @Bean
    public UserRealm getRealm() {
        return new UserRealm();
    }

    @Bean
    RememberMeManager cookieRememberMeManager() {
        CookieRememberMeManager cookieRememberMeManager = new CookieRememberMeManager();
        cookieRememberMeManager.setCipherKey(Base64.getDecoder().decode("QZIysgMYhG7/CzIJlVpR1g=="));
        return cookieRememberMeManager;
    }

    @Bean
    SecurityManager securityManager(UserRealm userRealm, RememberMeManager cookieRememberMeManager) {
        DefaultWebSecurityManager manager = new DefaultWebSecurityManager();
        manager.setRealm((Realm)userRealm);
        manager.setRememberMeManager(cookieRememberMeManager);
        return manager;
    }

    @Bean
    public ShiroFilterFactoryBean ShiroFilterFactoryBean(SecurityManager securityManager) {
        ShiroFilterFactoryBean shiroFilterFactoryBean = new ShiroFilterFactoryBean();
        shiroFilterFactoryBean.setSecurityManager(securityManager);
        shiroFilterFactoryBean.setLoginUrl("/admin/login");
        shiroFilterFactoryBean.setUnauthorizedUrl("/admin/loginFailed");
        LinkedHashMap<String, String> filterMap = new LinkedHashMap<String, String>();
        filterMap.put("/admin/login", "anon");
        filterMap.put("/admin/doLogin", "anon");
        filterMap.put("/admin/loginFailed", "anon");
        filterMap.put("/admin/home", "user");
        shiroFilterFactoryBean.setFilterChainDefinitionMap(filterMap);
        return shiroFilterFactoryBean;
    }
}

