/*
 * Decompiled with CFR 0.152.
 */
package com.example.doctoolkit.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

/*
 * Exception performing whole class analysis ignored.
 */
public class ZipUtils {
    private static final int BUFFER_SIZE = 2048;

    public static void toZip(String srcDir, OutputStream outFile, boolean KeepDirStructure) throws RuntimeException {
        long start = System.currentTimeMillis();
        ZipOutputStream zos = null;
        try {
            zos = new ZipOutputStream(outFile);
            File sourceFile = new File(srcDir);
            ZipUtils.compress((File)sourceFile, (ZipOutputStream)zos, (String)sourceFile.getName(), (boolean)KeepDirStructure);
            long end = System.currentTimeMillis();
            System.out.println("Compression is complete, time consuming: " + (end - start) + " ms");
        }
        catch (Exception e) {
            throw new RuntimeException("zip error from ZipUtils", e);
        }
        finally {
            if (zos != null) {
                try {
                    zos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected static void compress(File sourceFile, ZipOutputStream zos, String name, boolean KeepDirStructure) throws Exception {
        byte[] buf = new byte[2048];
        if (sourceFile.isFile()) {
            int len;
            zos.putNextEntry(new ZipEntry(name));
            FileInputStream in = new FileInputStream(sourceFile);
            while ((len = in.read(buf)) != -1) {
                zos.write(buf, 0, len);
            }
            zos.closeEntry();
            in.close();
        } else {
            File[] listFiles = sourceFile.listFiles();
            if (listFiles == null || listFiles.length == 0) {
                if (KeepDirStructure) {
                    zos.putNextEntry(new ZipEntry(name + "/"));
                    zos.closeEntry();
                }
            } else {
                for (File file : listFiles) {
                    if (KeepDirStructure) {
                        ZipUtils.compress((File)file, (ZipOutputStream)zos, (String)(name + "/" + file.getName()), (boolean)KeepDirStructure);
                        continue;
                    }
                    ZipUtils.compress((File)file, (ZipOutputStream)zos, (String)file.getName(), (boolean)KeepDirStructure);
                }
            }
        }
    }
}

