<?php /*a:3:{s:47:"/var/www/html/app/install/view/index/step2.html";i:1686239151;s:51:"/var/www/html/app/install/view/index/step-base.html";i:1686239151;s:45:"/var/www/html/app/install/view/index/css.html";i:1686239151;}*/ ?>
<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <meta charset="UTF-8">
    <title>安装环境检测 - FunAdmin管理系统安装</title>
    <meta property="og:keywords" content="FunAdmin Layui ThinkPHP6 Requirejs 管理框架" />
<meta property="og:description" content="FunAdmin是一款基于ThinkPHP6+Layui的敏捷后台开发框架" />
<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
<meta name="apple-mobile-web-app-status-bar-style" content="black">
<meta name="apple-mobile-web-app-capable" content="yes">
<meta name="format-detection" content="telephone=no"> <meta name="renderer" content="webkit">
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<link rel="shortcut icon" href="/favicon.ico" type="image/x-icon"/>
<link rel="stylesheet" type="text/css" href="/static/plugins/layui/css/layui.css" />
<script src="/static/plugins/layui/layui.js" v="2.7.2" e="layui"></script>
<script type="text/javascript" src="/static/plugins/jquery/jquery-3.6.0.min.js"></script>
<style>::-webkit-input-placeholder {
    color: #ccc
}

::-webkit-scrollbar {
    width: 5px !important;
    height: 6px !important;
    background: #ffffff !important;
    cursor: pointer !important
}

::-webkit-scrollbar-thumb {
    background-color: #9c9da0;
    -webkit-border-radius: 2em;
    -moz-border-radius: 2em;
    border-radius: 2em
}

::-webkit-scrollbar-track {
    -webkit-box-shadow: inset 0 0 5px rgba(240, 240, 240, .5) !important;
    border-radius: 0 !important;
    background: rgba(240, 240, 240, 0.5) !important;
    cursor: pointer !important
}
.layui-elem-quote{
    border-left: 5px solid #1e9fff!important;
}
.layui-btn-danger {
    background-color: #f76d6d !important
}

.layui-red {
    color: #f76d6d;
    font-size: 18px
}

.layui-container {
    max-width: 1024px !important;
    margin: 10px auto
}

.layui-container .install-h1 {
    line-height: 60px;
    color: #393D49;
    font-size: 28px;
    font-weight: 300;
    text-align: center
}

.layui-elem-quote {
    margin-bottom: 20px
}

.layui-elem-quote h1 {
    font-size: 24px;
    font-weight: 300;
    margin-bottom: 20px
}

.btn-box {
    text-align: center;
    margin: 30px 0
}

.layui-elem-quote > p {
    margin-bottom: 10px
}

.layui-elem-quote > p a {
    color: #1e9fff
}

.layui-elem-quote > p a:hover {
    color: #e86c6c
}

.protocol {
    width: 100%;
    height: 400px;
    padding: 10px 20px;
    background-color: #fff;
    overflow-y: scroll;
    box-sizing: border-box
}

.protocol h3 {
    text-align: center;
    font-size: 18px;
    margin: 10px 0 15px
}

.protocol h4 {
    font-size: 16px;
    margin-top: 10px;
    color: #333
}

.protocol p {
    line-height: 1.7;
    color: #555
}

.protocol span {
    margin-top: 20px;
    display: block;
    color: #999;
    font-size: 12px
}

input {
    -webkit-writing-mode: horizontal-tb !important;
    text-rendering: auto;
    color: #7E96B3;
    letter-spacing: normal;
    word-spacing: normal;
    text-transform: none;
    text-indent: 0px;
    text-shadow: none;
    display: inline-block;
    text-align: start;
    -webkit-appearance: textfield;
    background-color: rgb(255, 255, 255);
    -webkit-rtl-ordering: logical;
    cursor: text;
    margin: 0em;
    font: 400 13.3333px Arial;
    padding: 1px 0px;
    border-width: 2px;
    border-style: inset;
    border-color: rgb(118, 118, 118);
    border-image: initial;
    border-radius: 2px
}

input::-webkit-input-placeholder {
    color: #aab2bd;
    font-size: 12px
}

.layui-form-item {
    margin-bottom: 10px
}

.layui-form-item input:focus {
    background: #fff;
    color: #444;
    outline: none;
    border-color: #FF5722 !important
}

.layui-notice {
    text-align: center
}
#layui-success, .layui-success{
    background: #1e9fff;
    color: #fff;
    padding: 15px 20px;
    border-radius: 4px;
    margin-bottom: 20px
}
#layui-error, .layui-error, , #layui-warmtips, .layui-warmtips {
    background: #f76d6d;
    color: #fff;
    padding: 15px 20px;
    border-radius: 4px;
    margin-bottom: 20px
}

#layui-error a, .layui-error a {
    color: white;
    text-decoration: underline
}

#layui-warmtips {
    background: #ffcdcd;
    font-size: 14px;
    color: #f76d6d
}

#layui-warmtips a {
    background: #ffffff7a;
    display: block;
    height: 30px;
    line-height: 30px;
    margin-top: 10px;
    color: #f76d6d;
    border-radius: 3px
}

.submit {
    text-align: center
}

.footer {
    text-align: center
}

@media screen and(max-width: 1024px) {
    .layui-container {
        width: 100%
    }
}

@media screen and(max-width: 768px) {
    .layui-container {
        max-width: 100%
    }
}</style>
</head>
<body>
<style>
    .layui-icon-ok{
        font-size:18px;
        font-weight:bold;
        color: #009688;
    }
    .layui-icon-close{
        color: #FF5722;
    }
</style>
<div class="layui-container">
    <h1 class="install-h1">环境检测</h1>
    <?php if(is_file($config['lockFile'])):?>
    <div class="layui-error">
        当前已经安装FunAdmin，如果需要重新安装，请手动移除FunAdmin/public/install.lock文件
    </div>
    <?php endif;;?>
    <!--系统环境信息-->
    <table class="layui-table" lay-skin="line">
        <thead>
        <tr>
            <th width="25%">环境</th>
            <th width="25%">最低配置</th>
            <th width="25%">当前配置</th>
            <th width="25%">是否符合</th>
        </tr>
        </thead>
        <tr>
            <td>操作系统</td>
            <td>不限</td>
            <td><?php echo php_uname('s'); ?></td>
            <td><i class="layui-icon layui-icon-ok"></i></td>
        </tr>
        <tr>
            <td>php版本</td>
            <td>7.4+</td>
            <td><?php echo PHP_VERSION ?></td>
            <?php $php_version=explode('.', PHP_VERSION);?>
            <td>
                <?php if(version_compare(PHP_VERSION, '7.4.0', '>')): ?>
                <i class="layui-icon layui-icon-ok"></i>
                <?php else: ?>
                <i class="layui-icon layui-icon-close"></i>
                <?php endif; ?>
            </td>
        </tr>
    </table>
    <!--扩展插件信息-->
    <table class="layui-table" lay-skin="line">
        <thead>
        <tr>
            <th width="25%">扩展</th>
            <th width="25%">最低配置</th>
            <th width="25%">当前配置</th>
            <th width="25%">是否符合</th>
        </tr>
        </thead>
        <tr>
            <td>数据库模块</td>
            <td>MySQLi</td>
            <td><?php
                    $pdo = false;
                    if(class_exists('PDO', false))
                    {
                       if(defined('PDO::MYSQL_ATTR_USE_BUFFERED_QUERY'))
                        {
                            echo 'PDO_MYSQL';
                            $pdo = true;
                        }
                        else
                        {
                            echo '不支持PDO_MYSQL';
                        }
                    }
                    else
                    {
                        echo '不支持PDO_MYSQL';
                    }
                    if(!$pdo)
                    {
                        if (function_exists('mysqli_close'))
                        {
                            echo 'MySQLi';
                            $pdo = true;
                        }
                    }
                ?></td>
            <td>
                <?php if ($pdo): ?>
                <i class="layui-icon layui-icon-ok"></i>
                <?php else: ?>
                <i class="layui-icon layui-icon-close"></i>
                <?php endif; ?>
            </td>
        </tr>
        <tr>
            <td>PDO</td>
            <td>支持</td>
            <td>
                <?php if(extension_loaded('pdo')): ?>
                支持
                <?php else: ?>
                不支持
                <?php endif; ?>
            </td>
            <td>
                <?php if(extension_loaded('pdo')): ?>
                <i class="layui-icon layui-icon-ok"></i>
                <?php else: ?>
                <i class="layui-icon layui-icon-close"></i>
                <?php endif; ?>
            </td>
        </tr>
        <tr>
            <td>图象</td>
            <td>GD或IMagick</td>
            <td>
                <?php if(function_exists('gd_info')): if(class_exists('Imagick', false)): ?>
                ImageMagick
                <?php else: ?>
                GD
                <?php endif; else: ?>
                不支持
                <?php endif; ?>
            </td>
            <td>
                <?php if(function_exists('gd_info')): ?>
                <i class="layui-icon layui-icon-ok"></i>
                <?php else: ?>
                <i class="layui-icon layui-icon-close"></i>
                <?php endif; ?>
            </td>
        </tr>
        <tr>
















        </tr>
        <tr>
            <td>Session</td>
            <td>支持</td>
            <td>
                <?php if(function_exists('session_start')): ?>
                支持
                <?php else: ?>
                不支持
                <?php endif; ?>
            </td>
            <td>
                <?php if(function_exists('session_start')): ?>
                <i class="layui-icon layui-icon-ok"></i>
                <?php else: ?>
                <i class="layui-icon layui-icon-close"></i>
                <?php endif; ?>
            </td>
        </tr>
        <tr>
            <td>openssl</td>
            <td>支持</td>
            <td>
                <?php if(extension_loaded('openssl')): ?>
                支持
                <?php else: ?>
                不支持
                <?php endif; ?>
            </td>
            <td>
                <?php if(extension_loaded('openssl')): ?>
                <i class="layui-icon layui-icon-ok"></i>
                <?php else: ?>
                <i class="layui-icon layui-icon-close"></i>
                <?php endif; ?>
            </td>
        </tr>
        <tr>
            <td>CURL</td>
            <td>支持</td>
            <td>
                <?php if(function_exists('curl_exec')): ?>
                支持
                <?php else: ?>
                不支持
                <?php endif; ?>
            </td>
            <td>
                <?php if(function_exists('curl_exec')): ?>
                <i class="layui-icon layui-icon-ok"></i>
                <?php else: ?>
                <i class="layui-icon layui-icon-close"></i>
                <?php endif; ?>
            </td>
        </tr>
        <tr>
            <td>FreeType</td>
            <td>支持</td>
            <td>
                <?php if(function_exists('imageftbbox')): ?>
                支持
                <?php else: ?>
                不支持
                <?php endif; ?>
            </td>
            <td>
                <?php if(function_exists('imageftbbox')): ?>
                <i class="layui-icon layui-icon-ok"></i>
                <?php else: ?>
                <i class="layui-icon layui-icon-close"></i>
                <?php endif; ?>
            </td>
        </tr>
        <tr>
            <td>上传限制</td>
            <td>10M+</td>
            <td><?php echo get_cfg_var('upload_max_filesize'); ?></td>
            <td>
                <?php if(get_cfg_var('upload_max_filesize') >= 10): ?>
                <i class="layui-icon layui-icon-ok"></i>
                <?php else: ?>
                <i class="layui-icon layui-icon-close"></i>
                <?php endif; ?>
            </td>
        </tr>
    </table>
    <!--目录权限信息-->
    <table class="layui-table" lay-skin="line">
        <thead>
        <tr>
            <th width="25%">目录</th>
            <th width="25%">最低配置</th>
            <th width="25%">当前配置</th>
            <th width="25%">是否符合</th>
        </tr>
        </thead>
        <tr>
            <td><?php $config['runtimePath'];?>/runtime</td>
            <td>可写</td>
            <td>
                <?php if (is_writable($config['runtimePath'])): ?>
                可写
                <?php else: ?>
                不可写
                <?php endif; ?>
            </td>
            <td>
                <?php if (is_writable($config['runtimePath'])): ?>
                <i class="layui-icon layui-icon-ok"></i>
                <?php else: ?>
                <i class="layui-icon layui-icon-close"></i>
                <?php endif; ?>
            </td>
        </tr>
    </table>
    <div class="btn-box">
        <a class="layui-btn layui-btn-danger layui-btn-radius" href="/install.php/index/step1">上一步</a>
        <a class="layui-btn layui-btn-normal layui-btn-radius next" href="javascript:;" data-href="/install.php/index/step3">下一步</a>
    </div>
</div>
<script>
    layui.use('layer', function(){
        var $ = layui.jquery, layer = layui.layer;
        // 判断是否通过
        $(document).on("click",'.next',function(){
            // 判断检测是否达标
            if ("<?php echo file_exists($config['lockFile']); ?>")
            {
                layer.msg('已经安装了,如果需要重新安装请先删除public/install.lock');
                return false;
            }
            if($('.layui-icon-ok').length < 11){
                msg = msg?msg:'您的配置或权限未满足要求';
                layer.msg(msg);
            }else{
                window.location.href = $(this).data('href');
            }
        });
    });
</script>
</body>
</html>